// priority: 17

let 解析字符串 = (输入字符串) => {
    let 数量 = 1;
    let 物品ID = 输入字符串;
    if (输入字符串.includes("x ")) {
        let 部件 = 输入字符串.split("x ");
        数量 = parseInt(部件[0]);
        物品ID = 部件[1].trim();
    }
    let nbt = null;
    let nbt开始位置 = 物品ID.indexOf("{");
    if (nbt开始位置 !== -1) {
        nbt = 物品ID.substring(nbt开始位置);
        物品ID = 物品ID.substring(0, nbt开始位置);
    }
    return { "id": 物品ID, "nbt": nbt, "数量": 数量 };
};

let 获取物品指纹 = (物品栈) => {
    if (!物品栈 || !物品栈.id) return null;
    let nbt = 物品栈.nbt ? 物品栈.nbt.toString() : "{}";
    if (nbt === "null") nbt = "{}";
    return `${物品栈.id}${nbt}`;
};

let 检查维度是否匹配 = (配方, 世界) => {
    if (!配方.维度 || 配方.维度.length === 0) return true;
    let 目标维度ID列表 = 配方.维度.map(中文名 => 维度中文映射[中文名] || 中文名);
    return 目标维度ID列表.includes(世界.dimension.location().toString());
};


let 检查是否在结构内 = (世界, 位置, 结构名) => {
    if (!结构名) return true;
    
    let 结构ID = 结构中文映射[结构名] || 结构名;
    let 结构管理器 = 世界.structureManager();
    let 结构注册表 = 世界.registryAccess().registry($注册表类.STRUCTURE).get();
    let 目标结构资源位置 = new $资源位置(结构ID);
    let 目标结构 = 结构注册表.get(目标结构资源位置);

    if (!目标结构) return false;

    let 结构起点 = 结构管理器.getStructureAt(位置, 目标结构);
    return 结构起点 != null && 结构起点.isValid();
};

let 计算合成 = (配方, 材料统计, p) => {
    let 配方需求统计 = new Map();
    配方.合成材料.forEach(材料字符串 => {
        let 解析结果 = 解析字符串(材料字符串);
        let 临时物品 = 解析结果.nbt ? Item.of(解析结果.id, 1, 解析结果.nbt) : Item.of(解析结果.id);
        let 数据 = 获取物品指纹(临时物品);
        配方需求统计.set(数据, (配方需求统计.get(数据) || 0) + 解析结果.数量);
    });

    let 物品可合成数 = Infinity;
    配方需求统计.forEach((需要数量, 数据) => {
        let 拥有数量 = 材料统计.get(数据) || 0;
        物品可合成数 = Math.min(物品可合成数, Math.floor(拥有数量 / 需要数量));
    });

    let 最终可合成数 = 物品可合成数;
    if (配方.需要经验值 > 0) {
        if (p && !p.isCreative()) {
            最终可合成数 = Math.min(最终可合成数, Math.floor(p.totalExperience / 配方.需要经验值));
        } else if (!p) {
            最终可合成数 = 0;
        }
    }

    if (配方.触发方式 === "水池" || (配方.触发方式 === "全部" && 材料统计.has("minecraft:lapis_lazuli{}"))) {
        最终可合成数 = Math.min(最终可合成数, 材料统计.get("minecraft:lapis_lazuli{}") || 0);
    }

    if (最终可合成数 <= 0 || 最终可合成数 === Infinity) {
        return { "合成次数": 0, "待返还物品": new Map() };
    }
    
    let 待返还物品 = new Map(材料统计);
    配方需求统计.forEach((需要数量, 数据) => {
        待返还物品.set(数据, 待返还物品.get(数据) - (需要数量 * 最终可合成数));
    });
    
    if (配方.触发方式 === "水池" || (配方.触发方式 === "全部" && 材料统计.has("minecraft:lapis_lazuli{}"))) {
        待返还物品.set("minecraft:lapis_lazuli{}", (待返还物品.get("minecraft:lapis_lazuli{}") || 0) - 最终可合成数);
    }

    return { "合成次数": 最终可合成数, "待返还物品": 待返还物品 };
};

let 所有仪式材料ID = new Set(["minecraft:lapis_lazuli"]);
if (global.世界交互配方列表) {
    global.世界交互配方列表.forEach(配方 => {
        if (配方.合成材料) {
            配方.合成材料.forEach(材料字符串 => 所有仪式材料ID.add(解析字符串(材料字符串).id));
        }
    });
}

let 待检查的仪式物品 = [];
EntityEvents.spawned(e => {
    if (e.entity.type !== "minecraft:item") return;
    e.server.schedule(1, () => {
        let 实体 = e.entity;
        if (!实体 || !实体.isAlive()) return;
        if (实体.nbt.Thrower && 所有仪式材料ID.has(String(实体.item.id))) {
            待检查的仪式物品.push(实体);
        }
    });
});

ServerEvents.tick(e => {
    if (待检查的仪式物品.length === 0) return;
    for (let 甲 = 待检查的仪式物品.length - 1; 甲 >= 0; 甲--) {
        let 实体 = 待检查的仪式物品[甲];
        if (!实体.isAlive()) {
            待检查的仪式物品.splice(甲, 1);
            continue;
        }
        if (实体.item.id == "minecraft:lapis_lazuli" && 实体.level.getBlockState(实体.blockPosition()).is("minecraft:water")) {
            待检查的仪式物品.splice(甲, 1);
            if (寻找水池并检查(实体.level, 实体.blockPosition(), 实体.getOwner())) {
                待检查的仪式物品.length = 0; 
            }
        }
    }
});

let 寻找水池并检查 = (世界, 物品位置, p) => {
    let 可能的原点列表 = [物品位置, 物品位置.offset(-1, 0, 0), 物品位置.offset(0, 0, -1), 物品位置.offset(-1, 0, -1)];
    for (let 原点 of 可能的原点列表) {
        let 水池位置 = [原点, 原点.east(), 原点.south(), 原点.south().east()];
        if (水池位置.every(位置 => 世界.getFluidState(位置).isSource())) {
            let 水池被正确隔离 = true;
            for (let x偏移 = -1; x偏移 <= 2; x偏移++) {
                for (let z偏移 = -1; z偏移 <= 2; z偏移++) {
                    if (x偏移 >= 0 && x偏移 <= 1 && z偏移 >= 0 && z偏移 <= 1) continue;
                    if (!世界.getFluidState(原点.offset(x偏移, 0, z偏移)).isEmpty()) {
                        水池被正确隔离 = false;
                        break;
                    }
                }
                if (!水池被正确隔离) break;
            }
            if (水池被正确隔离 && 检查并执行水池仪式(世界, 原点, p)) {
                return true; 
            }
        }
    }
    return false;
};

let 检查并执行水池仪式 = (世界, 水池原点, p) => {
    let 搜索区域 = new $AABB(水池原点.x, 水池原点.y, 水池原点.z, 水池原点.x + 2, 水池原点.y + 1, 水池原点.z + 2);
    let 水中物品实体 = 世界.getEntitiesOfClass($实体物品类, 搜索区域);
    if (水中物品实体.length === 0) return false;
    
    let 材料统计 = new Map();
    水中物品实体.forEach(实体 => 材料统计.set(获取物品指纹(实体.item), (材料统计.get(获取物品指纹(实体.item)) || 0) + 实体.item.count));

    let 最佳匹配配方 = null;
    let 最高匹配分数 = -1;
    for (let 配方 of global.世界交互配方列表) {
        let 触发方式 = 配方.触发方式 || "全部";
        if (触发方式 !== "水池" && 触发方式 !== "全部") continue;
        let 需求材料数据 = new Set();
        配方.合成材料.forEach(材料字符串 => 需求材料数据.add(获取物品指纹(Item.of(解析字符串(材料字符串).id, 1, 解析字符串(材料字符串).nbt))));
        let 当前匹配分数 = 0;
        材料统计.forEach((_, 数据) => { if (需求材料数据.has(数据)) 当前匹配分数++; });
        if (当前匹配分数 > 最高匹配分数) {
            最高匹配分数 = 当前匹配分数;
            最佳匹配配方 = 配方;
        }
    }
    if (!最佳匹配配方) return false;

    let 结果 = 计算合成(最佳匹配配方, 材料统计, p);
    let 维度匹配 = 检查维度是否匹配(最佳匹配配方, 世界);
    let 高度匹配 = 最佳匹配配方.仪式高度 === undefined || 水池原点.y === 最佳匹配配方.仪式高度;
    let 仪式位置匹配 = 检查是否在结构内(世界, 水池原点, 最佳匹配配方.需要结构);
    let 结构方块是否满足 = true;
    if (最佳匹配配方.结构方块 && 最佳匹配配方.结构方块.length > 0) {
        let 找到的方块统计 = new Map();
        for (let x偏移 = -1; x偏移 <= 2; x偏移++) {
            for (let z偏移 = -1; z偏移 <= 2; z偏移++) {
                if (x偏移 >= 0 && x偏移 <= 1 && z偏移 >= 0 && z偏移 <= 1) continue;
                let 方块ID = String(世界.getBlockState(水池原点.offset(x偏移, 0, z偏移)).block.id);
                if (方块ID !== "minecraft:air") 找到的方块统计.set(方块ID, (找到的方块统计.get(方块ID) || 0) + 1);
            }
        }
        结构方块是否满足 = 最佳匹配配方.结构方块.every(需求字符串 => (找到的方块统计.get(解析字符串(需求字符串).id) || 0) >= 解析字符串(需求字符串).数量);
    }

    if (维度匹配 && 高度匹配 && 结构方块是否满足 && 仪式位置匹配 && 结果.合成次数 > 0) {
        let 总经验消耗 = (最佳匹配配方.需要经验值 || 0) * 结果.合成次数;
        if (p && !p.isCreative() && 总经验消耗 > 0) p.giveExperiencePoints(-总经验消耗);
        水中物品实体.forEach(实体 => 实体.discard());
        let 中心X = 水池原点.x + 1, 中心Y = 水池原点.y + 0.5, 中心Z = 水池原点.z + 1;
        let 新闪电 = 世界.createEntity("minecraft:lightning_bolt");
        新闪电.setPosition(中心X, 中心Y, 中心Z);
        新闪电.spawn();
        生成物品(世界, 中心X, 中心Y, 中心Z, 最佳匹配配方.输出物品, 结果.合成次数 * (最佳匹配配方.输出数量 || 1));
        结果.待返还物品.forEach((数量, 数据) => { if (数量 > 0) 生成物品(世界, 中心X, 中心Y, 中心Z, 数据, 数量); });
        return true; 
    } else if (p) {
        let 结构显示名 = 结构中文映射[最佳匹配配方.需要结构] ? 最佳匹配配方.需要结构 : (最佳匹配配方.需要结构 || "未知结构");
        if (!维度匹配) p.tell(Component.translate("kubejs.message.ritual.wrong_dimension"));
        else if (!仪式位置匹配) p.tell(Component.translate("kubejs.message.ritual.wrong_structure_name", Text.aqua(结构显示名)));
        else if (!结构方块是否满足) p.tell(Component.translate("kubejs.message.ritual.incomplete_altar"));
        else if (最佳匹配配方.需要经验值 > 0 && p.totalExperience < 最佳匹配配方.需要经验值) p.tell(Component.translate("kubejs.message.ritual.not_enough_xp", Text.green(最佳匹配配方.需要经验值)));
        else if (结果.合成次数 <= 0) p.tell(Component.translate("kubejs.message.ritual.incorrect_materials"));
    }
    return false;
};

NativeEvents.onEvent(Java.loadClass("net.minecraftforge.event.entity.EntityStruckByLightningEvent"), e => {
    let 闪电 = e.getLightning();
    let 世界 = 闪电.level;
    if (世界.isClientSide()) return;

    let 被击中实体 = 世界.getEntitiesOfClass($实体物品类, 闪电.getBoundingBox().inflate(3));
    if (被击中实体.length === 0) return;
    let 被击中实体列表 = 被击中实体.filter(实体 => 世界.getBlockState(实体.blockPosition()).isAir());
    if (被击中实体列表.length === 0) return;

    let 材料统计 = new Map();
    被击中实体列表.forEach(实体 => 材料统计.set(获取物品指纹(实体.item), (材料统计.get(获取物品指纹(实体.item)) || 0) + 实体.item.count));

    let p = null;
    for (let 实体 of 被击中实体列表) {
        if (实体.nbt && 实体.nbt.Thrower) p = 世界.getPlayerByUUID(实体.nbt.Thrower);
        if (p) break;
    }
    
    let 最佳匹配配方 = null;
    let 最高匹配分数 = -1;
    for (let 配方 of global.世界交互配方列表) {
        let 触发方式 = 配方.触发方式 || "全部";
        if (触发方式 !== "闪电" && 触发方式 !== "全部") continue;
        let 需求材料数据 = new Set();
        配方.合成材料.forEach(材料字符串 => 需求材料数据.add(获取物品指纹(Item.of(解析字符串(材料字符串).id, 1, 解析字符串(材料字符串).nbt))));
        let 当前匹配分数 = 0;
        材料统计.forEach((_, 数据) => { if (需求材料数据.has(数据)) 当前匹配分数++; });
        if (当前匹配分数 > 最高匹配分数) {
            最高匹配分数 = 当前匹配分数;
            最佳匹配配方 = 配方;
        }
    }
    if (!最佳匹配配方) return;

    let 结果 = 计算合成(最佳匹配配方, 材料统计, p);
    let 维度匹配 = 检查维度是否匹配(最佳匹配配方, 世界);
    let 高度匹配 = 最佳匹配配方.闪电Y轴限制 === undefined || 闪电.getY() >= 最佳匹配配方.闪电Y轴限制;
    let 仪式位置匹配 = 检查是否在结构内(世界, 闪电.blockPosition(), 最佳匹配配方.需要结构);
    
    if (维度匹配 && 高度匹配 && 仪式位置匹配 && 结果.合成次数 > 0) {
        let 总经验消耗 = (最佳匹配配方.需要经验值 || 0) * 结果.合成次数;
        if (p && !p.isCreative() && 总经验消耗 > 0) p.giveExperiencePoints(-总经验消耗);
        被击中实体列表.forEach(实体 => 实体.discard());
        生成物品(世界, 闪电.x, 闪电.y, 闪电.z, 最佳匹配配方.输出物品, 结果.合成次数 * (最佳匹配配方.输出数量 || 1));
        结果.待返还物品.forEach((数量, 数据) => { if (数量 > 0) 生成物品(世界, 闪电.x, 闪电.y, 闪电.z, 数据, 数量); });
        e.cancel();
    } else if (p) {
        let 结构显示名 = 结构中文映射[最佳匹配配方.需要结构] ? 最佳匹配配方.需要结构 : (最佳匹配配方.需要结构 || "未知结构");
        if (!维度匹配) p.tell(Component.translate("kubejs.message.ritual.wrong_dimension"));
        else if (!仪式位置匹配) p.tell(Component.translate("kubejs.message.ritual.wrong_structure_name", Text.aqua(结构显示名)));
        else if (最佳匹配配方.需要经验值 > 0 && p.totalExperience < 最佳匹配配方.需要经验值) p.tell(Component.translate("kubejs.message.ritual.not_enough_xp", Text.green(最佳匹配配方.需要经验值)));
        else if (结果.合成次数 <= 0) p.tell(Component.translate("kubejs.message.ritual.incorrect_materials"));
    }
});

let 生成物品 = (世界, x, y, z, 物品字符串, 总数量) => {
    let 剩余数量 = 总数量;
    while (剩余数量 > 0) {
        let 本次数量 = Math.min(剩余数量, 64);
        let 新物品 = 世界.createEntity("item");
        let 解析结果 = 解析字符串(物品字符串);
        let 物品栈 = 解析结果.nbt ? Item.of(解析结果.id, 本次数量, 解析结果.nbt) : Item.of(解析结果.id, 本次数量);
        新物品.item = 物品栈;
        新物品.setPosition(x, y, z);
        新物品.attack(-21e10);
        新物品.spawn();
        剩余数量 -= 本次数量;
    }
};